<?php

/* * Exit if accessed directly */
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/* * Check if WooCommerce is active */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/* * Init plugin */
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) && !class_exists( 'WC_DPDFrance_Settings_Classic' ) ) {
	/* * Main class */

	class WC_DPDFrance_Settings_Classic {
		/**
		 * Classic settings form fields
		 * @return array
		 */
		public static function settings_classic(): array {
			return [
				'enabled'             => [
					'title'   => __( 'Enable/Disable', 'woocommerce-dpdfrance' ),
					'type'    => 'checkbox',
					'label'   => __( 'Enable DPD CLASSIC delivery', 'woocommerce-dpdfrance' ),
					'default' => 'yes'
				],
				'title'               => [
					'title'       => __( 'Title', 'woocommerce-dpdfrance' ),
					'type'        => 'text',
					'description' => __( 'This controls the title which the user sees during checkout.', 'woocommerce-dpdfrance' ),
					'default'     => __( 'Delivery at workplace', 'woocommerce-dpdfrance' )
				],
				'depot_code'          => [
					'title'       => __( 'Your DPD Depot code', 'woocommerce-dpdfrance' ),
					'type'        => 'text',
					'description' => __( 'Don\'t hesitate to contact your DPD sales representative to obtain this data', 'woocommerce-dpdfrance' ),
				],
				'shipper_code'        => [
					'title'       => __( 'Your DPD CLASSIC contract number', 'woocommerce-dpdfrance' ),
					'type'        => 'text',
					'description' => __( 'Don\'t hesitate to contact your DPD sales representative to obtain this data', 'woocommerce-dpdfrance' ),
				],
				'tax_status'          => [
					'title'   => __( 'Tax Status', 'woocommerce-dpdfrance' ),
					'type'    => 'select',
					'default' => 'taxable',
					'options' => [
						'taxable' => __( 'Taxable', 'woocommerce-dpdfrance' ),
						'none'    => __( 'None', 'woocommerce-dpdfrance' ),
					],
				],
				'handling_fee'        => [
					'title'       => __( 'Handling Fee', 'woocommerce-dpdfrance' ),
					'description' => __( 'Fee, excluding tax. Leave blank to disable.', 'woocommerce-dpdfrance' ),
					'type'        => 'price',
					'default'     => '0.00',
					'desc_tip'    => true,
				],
				'supp_montagne'       => [
					'title'       => __( 'Mountain area Overcost', 'woocommerce-dpdfrance' ),
					'description' => __( 'Fee, excluding tax. Enter -1 to disable delivery to these areas.', 'woocommerce-dpdfrance' ),
					'type'        => 'price',
					'default'     => '0.00',
					'desc_tip'    => true,
				],
				'supp_iles'           => [
					'title'       => __( 'Coastal Islands & Corsica Overcost', 'woocommerce-dpdfrance' ),
					'description' => __( 'Fee, excluding tax. Enter -1 to disable delivery to these areas.', 'woocommerce-dpdfrance' ),
					'type'        => 'price',
					'default'     => '0.00',
					'desc_tip'    => true,
				],
				'franco'              => [
					'title'       => __( 'Offer free shipping for orders above this amount', 'woocommerce-dpdfrance' ),
					'description' => __( 'Disable this feature with a zero value.', 'woocommerce-dpdfrance' ),
					'type'        => 'price',
					'default'     => '0.00',
					'desc_tip'    => true,
				],
				'max_weight'          => [
					'title'       => __( 'Disable shipping method for orders above this weight', 'woocommerce-dpdfrance' ) . ' (' . get_option( 'woocommerce_weight_unit' ) . ')',
					'description' => __( 'Disable this feature with a zero value.', 'woocommerce-dpdfrance' ),
					'type'        => 'text',
					'default'     => (string)((float)WC_DPDFrance_Tools::get_converted_parcel_weight_dpd_setting( get_option( 'woocommerce_weight_unit' ), 30)),
					'desc_tip'    => true,
				],
				'coupon_freeshipping' => [
					'title'       => __( 'Enable free shipping coupons management', 'woocommerce-dpdfrance' ),
					'description' => __( 'If the customer applies a valid coupon, shipping will be free.', 'woocommerce-dpdfrance' ),
					'desc_tip'    => true,
					'type'        => 'select',
					'default'     => 'enabled',
					'options'     => [
						'enabled'  => __( 'Enabled', 'woocommerce-dpdfrance' ),
						'disabled' => __( 'Disabled', 'woocommerce-dpdfrance' ),
					],
				],
				'classes_to_exclude'  => [
					'title'       => __( 'Shipping classes to exclude', 'woocommerce-dpdfrance' ),
					'description' => __( 'Specify the shipping classes identifiers to exclude, each one separated by a comma ","', 'woocommerce-dpdfrance' ),
					'desc_tip'    => true,
					'type'        => 'text',
				],
				'zones_table'         => [
					'type' => 'zones_table',
				],
				'table_rates_table'   => [
					'type' => 'table_rates_table'
				],
			];
		}
	}
}
