<?php
/* Exit if accessed directly */
if (!defined('ABSPATH'))
    exit;

/**
 * Install table.
 *
 * @access public
 * @return void
 */
function install_table() 
{
    global $wpdb;
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    $time = time();
    $sql = "
        CREATE TABLE IF NOT EXISTS {$wpdb->prefix}woocommerce_dpdfrance (
            `id_cart` varchar(32) NOT NULL,
            `service` varchar(3) DEFAULT NULL,
            `relay_id` varchar(8) DEFAULT NULL,
            `company` varchar(255) DEFAULT NULL,
            `address1` varchar(255) DEFAULT NULL,
            `address2` varchar(127) DEFAULT NULL,
            `postcode` varchar(15) DEFAULT NULL,
            `city` varchar(127) DEFAULT NULL,
            `gsm_dest` varchar(15) DEFAULT NULL,
            `date_creation` datetime DEFAULT NULL) 
            DEFAULT CHARSET=utf8";
    $wpdb->query($sql);
    
    $sql = "INSERT IGNORE INTO `wp_options`(`option_id`, `option_name`, `option_value`, `autoload`) VALUES ('','dpdfrance_last_tracking',{$time},'')";
    $wpdb->query($sql);
}

/**
 * Uninstall table.
 *
 * @access public
 * @return void
 */
function uninstall_table() 
{
    global $wpdb;
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    
    $sql = "DROP TABLE IF EXISTS {$wpdb->prefix}woocommerce_dpdfrance";
    $wpdb->query($sql);
}