<?php


/* * Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/* * Check if WooCommerce is active */
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
/* * Init plugin */
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) && !class_exists( 'WC_DPDFrance_Constants' ) ) {
	/* * Main class */

	class WC_DPDFrance_Constants {
		const DISPLAY_RELAIS_SUGGESTION_NUMBER = 5;
		const ERROR_ISLAND_ZONE         = 1;
		const ERROR_MOUNTAIN_ZONE       = 2;
		const HAS_EXCLUDED_PRODUCT      = 3;
		const OVERWEIGHT                = 4;
		const DPD_SHIPPING_METHODS      = [
			'dpdfrance_classic',
			'dpdfrance_predict',
			'dpdfrance_relais',
			'dpdfrance_world'
		];
		const WEEKDAYS                  = [
			1 => 'monday',
			2 => 'tuesday',
			3 => 'wednesday',
			4 => 'thursday',
			5 => 'friday',
			6 => 'saturday',
			7 => 'sunday'
		];
		const MOUNTAINS_ZONE            = [
			'04120', '04130', '04140', '04160', '04170', '04200', '04240', '04260', '04300', '04310', '04330',
			'04360', '04370', '04400', '04510', '04530', '04600', '04700', '04850', '05100', '05110', '05120',
			'05130', '05150', '05160', '05170', '05200', '05220', '05240', '05250', '05260', '05290', '05300',
			'05310', '05320', '05330', '05340', '05350', '05400', '05460', '05470', '05500', '05560', '05600',
			'05700', '05800', '06140', '06380', '06390', '06410', '06420', '06430', '06450', '06470', '06530',
			'06540', '06620', '06710', '06750', '06910', '09110', '09140', '09300', '09460', '25120', '25140',
			'25240', '25370', '25450', '25500', '25650', '30570', '31110', '38112', '38114', '38142', '38190',
			'38250', '38350', '38380', '38410', '38580', '38660', '38700', '38750', '38860', '38880', '39220',
			'39310', '39400', '63113', '63210', '63240', '63610', '63660', '63690', '63840', '63850', '64440',
			'64490', '64560', '64570', '65110', '65120', '65170', '65200', '65240', '65400', '65510', '65710',
			'66210', '66760', '66800', '68140', '68610', '68650', '73110', '73120', '73130', '73140', '73150',
			'73160', '73170', '73190', '73210', '73220', '73230', '73250', '73260', '73270', '73300', '73320',
			'73340', '73350', '73390', '73400', '73440', '73450', '73460', '73470', '73500', '73530', '73550',
			'73590', '73600', '73620', '73630', '73640', '73710', '73720', '73870', '74110', '74120', '74170',
			'74220', '74230', '74260', '74310', '74340', '74350', '74360', '74390', '74400', '74420', '74430',
			'74440', '74450', '74470', '74480', '74660', '74740', '74920', '83111', '83440', '83530', '83560',
			'83630', '83690', '83830', '83840', '84390', '88310', '88340', '88370', '88400', '90200'
		];
		const ISLANDS_ZONE              = [
			'17111', '17123', '17190', '17310', '17370', '17410', '17480', '17550', '17580', '17590',
			'17630', '17650', '17670', '17740', '17840', '17880', '17940', '22870', '29242', '29253',
			'29259', '29980', '29990', '56360', '56590', '56780', '56840', '85350'
		];
		const ISO_STANDARD              = [
			"DE", "AD", "AT", "BE", "BA", "BG", "HR", "DK", "ES", "EE", "FI", "FR",
			"GB", "GR", "GG", "HU", "IM", "IE", "IT", "JE", "LV", "LI", "LT", "LU",
			"MC", "NO", "NL", "PL", "PT", "CZ", "RO", "RS", "SK", "SI", "SE", "CH"
		];
		const ISO_EPRINT                = [
			"D", "AND", "A", "B", "BA", "BG", "CRO", "DK", "E", "EST", "SF", "F",
			"GB", "GR", "GG", "H", "IM", "IRL", "I", "JE", "LET", "LIE", "LIT", "L",
			"F", "N", "NL", "PL", "P", "CZ", "RO", "RS", "SK", "SLO", "S", "CH"
		];

	}
}
