/**
 * Plugin Name: DPD France
 * Plugin URI: http://www.dpd.fr/ecommerce
 * Description: Module de livraison DPD pour WooCommerce 2 & 3 (France uniquement)
 * Version: 5.3.3
 * Author: DPD France S.A.S.
 * Author URI: http://www.dpd.fr/
 * License: Open Software License (OSL 3.0) - http://opensource.org/licenses/osl-3.0.php
 */

/**
 * Init Google Map Settings
 */
const initializeDpdfrance = (baseurl, mapId, lat, long) => {
    let latLong   = new google.maps.LatLng(lat, long);
    let myOptions = {
        zoom     : 16,
        center   : latLong,
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        styles   : [
            {"featureType": "landscape", "stylers": [{"visibility": "on"}, {"color": "#e6e7e7"}]},
            {
                "featureType": "poi.sports_complex",
                "stylers"    : [{"visibility": "on"}]
            },
            {"featureType": "poi.attraction", "stylers": [{"visibility": "off"}]},
            {
                "featureType": "poi.government",
                "stylers"    : [{"visibility": "on"}]
            },
            {"featureType": "poi.medical", "stylers": [{"visibility": "on"}]},
            {
                "featureType": "poi.place_of_worship",
                "stylers"    : [{"visibility": "on"}]
            },
            {"featureType": "poi.school", "stylers": [{"visibility": "on"}]},
            {
                "featureType": "water",
                "elementType": "geometry",
                "stylers"    : [{"visibility": "on"}, {"color": "#d2e4f3"}]
            },
            {"featureType": "water", "elementType": "labels", "stylers": [{"visibility": "on"}]},
            {
                "featureType": "transit",
                "elementType": "labels",
                "stylers"    : [{"visibility": "off"}]
            },
            {
                "featureType": "road",
                "elementType": "geometry.fill",
                "stylers"    : [{"visibility": "on"}, {"color": "#ffffff"}]
            },
            {
                "featureType": "road",
                "elementType": "geometry.stroke",
                "stylers"    : [{"visibility": "on"}, {"color": "#e6e7e7"}]
            },
            {"elementType": "labels.text.fill", "stylers": [{"visibility": "on"}, {"color": "#666666"}]},
            {
                "featureType": "poi.business",
                "stylers"    : [{"visibility": "off"}]
            },
            {"featureType": "road", "elementType": "labels.icon", "stylers": [{"visibility": "off"}]},
            {
                "featureType": "poi",
                "elementType": "geometry.fill",
                "stylers"    : [{"visibility": "on"}, {"color": "#dbdbdb"}]
            },
            {
                "featureType": "administrative.locality",
                "elementType": "labels.text.fill",
                "stylers"    : [{"visibility": "on"}, {"color": "#808285"}]
            },
            {"featureType": "transit.station", "stylers": [{"visibility": "on"}]},
            {
                "featureType": "transit",
                "elementType": "geometry",
                "stylers"    : [{"visibility": "on"}, {"color": "#dbdbdb"}]
            },
            {"elementType": "labels.icon", "stylers": [{"visibility": "on"}, {"saturation": -100}]},
            {
                "featureType": "road",
                "elementType": "labels.icon",
                "stylers"    : [{"visibility": "off"}]
            },
            {"elementType": "labels.text", "stylers": [{"visibility": "on"}]},
            {
                "featureType": "transit.line",
                "elementType": "labels.text",
                "stylers"    : [{"visibility": "off"}]
            }
        ]
    };
    let map       = new google.maps.Map(document.getElementById(mapId), myOptions);
    let marker    = new google.maps.Marker(
        {
            icon     : baseurl + "/assets/img/front/relais/logo-max-png.png",
            position : latLong,
            animation: google.maps.Animation.DROP,
            map      : map
        }
    );
}

/**
 * Open relais modal info from relais available list
 */
let openDpdfranceDialog = (baseurl, id, mapId, lat, long) => {
    $("#dpdfrance_relais_filter").fadeIn(150, function () {
        $("#" + id).fadeIn(150);
    });
    window.setTimeout(function () {
        initializeDpdfrance(baseurl, mapId, lat, long)
    }, 200);
}

/**
 * Check Relais ID pattern and his value, switch the place order button state (hide or show), return true if button is enabled and false if the button is disabled
 */
const switchPlaceOrderStateAndCheckRelaisValue = () => {
    let regexPattern             = new RegExp(/\(P\d{5}\)/);
    let company                  = document.getElementById('shipping_company');
    let selectedPickup           = document.querySelector("input[name=dpdfrance_relay_id]:checked");
    let selectedPickupID         = selectedPickup.id;
    let differentAddressCheckBox = document.getElementById("ship-to-different-address-checkbox");
    /**
     * If company input field is present in DOM
     */
    if (company) {
        let pickUpId = company.value.substr(-7, 6);
        /**
         * Different address checkbox is checked,
         * Check company value has relais ID,
         * Selected Pick Ip is not empty and
         * Check the selected pickup value id matched with the pickup id on company field
         */
        if (
            differentAddressCheckBox.checked === true &&
            regexPattern.test(company.value) &&
            selectedPickup.value !== null &&
            pickUpId === selectedPickupID
        ) {
            switchPlaceOrderButtonEnabled(true);
            document.querySelector('#' + pickUpId).checked = true;
            return true;
        }
        switchPlaceOrderButtonEnabled(false)
        return false;
    }

    /**
     * If there is no company input field,
     * Check if different address checkbox is checked
     * Selected pickup has value
     */
    if (
        differentAddressCheckBox.checked === true &&
        selectedPickup.value !== null
    ) {
        switchPlaceOrderButtonEnabled(true);
        document.querySelector('#' + selectedPickupID).checked = true;
        return true;
    }
    switchPlaceOrderButtonEnabled(false)
    return false;
}

/**
 * Check if relais shipping method is selected then do the place order button state process
 */
const isRelaisShippingCheckedThenProcessButton = () => {
    document.querySelector('.shipping_method:checked').value === 'dpdfrance_relais' && switchPlaceOrderStateAndCheckRelaisValue();
}

/**
 * Set Selected relais value to the shipping address
 */
const dpdWriteRelaisValues = (selectedRelais) => {
    /**
     * If checkbox another address not checked then check it
     */
    let differentAddressCheckbox = document.querySelector('#ship-to-different-address-checkbox');

    /**
     *  HIDDEN - If different address is not check then click it
     */
    if (differentAddressCheckbox.checked === false) {
        differentAddressCheckbox.click();
    }

    /**
     * Set the selected relais value to the shipping address
     */
    let relaisDatas                                      = JSON.parse(selectedRelais.value);
    let postcodeDifferent                                = document.querySelector("#shipping_postcode").value !== relaisDatas.postal_code ? 1 : 0;
    let company                                          = document.getElementById('shipping_company');
    document.querySelector("#shipping_first_name").value = document.querySelector("#billing_first_name").value;
    document.querySelector("#shipping_last_name").value  = document.querySelector("#billing_last_name").value;
    if (company !== null) {
        document.querySelector("#shipping_company").value = relaisDatas.shop_name + ' (' + relaisDatas.relay_id + ')';
    }
    document.querySelector('#shipping_country').value = 'FR';
    $('#select2-shipping_country-container').html('France');
    document.querySelector('#shipping_address_1').value = relaisDatas.address1;
    document.querySelector('#shipping_address_2').value = company !== null ?
                                                          relaisDatas.address2 ?? relaisDatas.shop_name + ' (' + relaisDatas.relay_id + ')' :
                                                          relaisDatas.shop_name + ' (' + relaisDatas.relay_id + ')';
    document.querySelector("#shipping_postcode").value  = relaisDatas.postal_code;
    document.querySelector("#shipping_city").value      = relaisDatas.city;
    displayShippingAddressForm(true)
    if (postcodeDifferent === 1) {
        $('#shipping_postcode').trigger({type: 'keydown', which: 13, keyCode: 13});
    }
    switchPlaceOrderStateAndCheckRelaisValue();
}

/**
 * Reset shipping address to the billing address, hide shipping address fields, uncheck checkbox another address and press enter on postcode field
 */
const resetAddressValues = (addr2) => {
    document.querySelector('#shipping_first_name').value = document.querySelector('#billing_first_name').value;
    document.querySelector('#shipping_last_name').value  = document.querySelector('#billing_last_name').value;
    document.querySelector('#shipping_address_1').value  = document.querySelector('#billing_address_1').value;
    document.querySelector('#shipping_address_2').value  = addr2;
    document.querySelector('#shipping_postcode').value   = document.querySelector('#billing_postcode').value;
    document.querySelector('#shipping_city').value       = document.querySelector('#billing_city').value;
    document.querySelector('#shipping_country').value    = document.querySelector('#billing_country').value;
    displayShippingAddressForm(false);
    checkShipToDifferentAddress(false);
    $('#shipping_postcode').trigger({type: 'keydown', which: 13, keyCode: 13});
}

/**
 * Function loaded when we are in the checkout page Shipping input values by the billing address input
 */
const dpdResetRelaisValues = () => {
    let relaisShippingMethodRadioButton = document.querySelector("input[id='shipping_method_0_dpdfrance_relais']");

    /**
     * If there is no relais shipping method then exit, do nothing
     */
    if (!relaisShippingMethodRadioButton) {
        return false;
    }

    let regex                         = new RegExp(/\(P\d{5}\)/);
    let company                       = document.getElementById('shipping_company');
    let differentAddressCheckboxState = document.querySelector('#ship-to-different-address-checkbox').checked;
    let billingAddress2Value          = document.querySelector('#billing_address_2').value;

    /**
     * Action when shipping method is not relais then reset shipping address to the billing address
     */
    if (relaisShippingMethodRadioButton.checked === true) {
        // * With Company Shipping Input
        if (company && regex.test(company.value) && differentAddressCheckboxState) {
            document.querySelector('#shipping_company').value = document.querySelector('#billing_company').value;
            resetAddressValues(billingAddress2Value);
        }

        // * Without Company Shipping Input
        if (!company && differentAddressCheckboxState) {
            let selectedRelaisValue = document.querySelector('.dpdfrance_radiopr input[name="dpdfrance_relay_id"]:checked').value;
            let relaisData          = $.parseJSON(selectedRelaisValue);
            let address2            = relaisData.shop_name + ' (' + relaisData.relay_id + ')';
            resetAddressValues(address2);
        }
    } else {
        /**
         * Action when shipping method is not relais then reset shipping address to the billing address
         */

        // * With Company Shipping Input
        if (company && regex.test(company.value) && differentAddressCheckboxState) {
            document.querySelector('#shipping_company').value = document.querySelector('#billing_company').value;
            resetAddressValues(billingAddress2Value);
        }

        // * Without Company Shipping Input
        if (!company && differentAddressCheckboxState) {
            resetAddressValues(billingAddress2Value);
        }
    }
}

/**
 * Update relais suggestions
 */
let dpdfrance_relais_ajaxupdate = (address, zipcode, city, action) => {
    if (
        (zipcode && zipcode.length >= 5 && action === 'search') ||
        action === 'reset'
    ) {
        let loadingImg = `${relaisVars.pluginsUrl}/woocommerce-dpdfrance/assets/img/front/relais/loader.gif`;
        $('#dpdfrance_reset_submit').after(`<img src="${loadingImg}" alt="loader"/>`);
        $.ajax(
            {
                url : `${relaisVars.pluginsUrl}/woocommerce-dpdfrance/ajax/getpoints.php?action=getajaxpoints`,
                data: {
                    'address': address,
                    'zipcode': zipcode,
                    'city'   : city
                }
            }
        ).done((data) => {
            let $table_relais_html = $(data);
            $('.dpdfrance_relaisbox').remove();
            $('#dpdfrance_relais_point_table').html($table_relais_html);
        }).fail((err) => {
            console.error("Error: Failed to get searched pickup points");
        });
    } else {
        document.querySelector('#dpdfrance_search_zipcode').style.border = '1px solid #dc0032';
    }
}

/**
 * Action once the DOM is fully loaded
 */
$(document).ready(() => {
    /**
     *  Disable Enter button on checkout form
     */
    $("form[name='checkout']").bind("keydown", function (e) {
        let enterKeyCaps = e.keyCode || e.which;
        if (enterKeyCaps === 13) {
            e.preventDefault();
            return false;
        }
    });

    /**
     *  Au changement de pays si nous sommes sur le relais, cela va sélectionner le classic
     */
    $(document.body).on('change', 'select[name=billing_country]', function () {
        if ($(this).val() !== "FR") {
            let shippingMethodList = getShippingMethodList();
            if (shippingMethodList.length === 0) {
                /* TODO : Si je n'ai que le relais en methode de livraison, enlever le relais a la selection d'un autre pays que la france*/
            }
            shippingMethodList.forEach(function (shippingMethod, index) {
                if (shippingMethod.value !== 'dpdfrance_relais') {
                    shippingMethod.checked = true;
                    return false;
                }
            })
        }
    });
});

/**
 * On Shipping method modification event, if shipping method is relais, we hide the shipping fields
 */
$(document).on('change', 'input[class=shipping_method]', (event) => {
    let selectedShippingMethod = event.currentTarget.value;
    if (selectedShippingMethod === 'dpdfrance_relais') {
        isRelaisShippingCheckedThenProcessButton()
    }
});