<?php

/* Load WordPress engine */
$wp_root_path = dirname(__FILE__, 5);
$wpLoadPath   = $wp_root_path . '/wp-load.php';
if (!file_exists($wpLoadPath)) {
    /** Compatibility with BedRock*/
    $wpLoadPath = $wp_root_path . '/wp/wp-load.php';
}
require($wpLoadPath);

/* Load translations */
load_textdomain( 'woocommerce-dpdfrance', basename( __DIR__ ) . '/../../languages/plugins/' );

/* Init vars */
ini_set( 'max_execution_time', 600 );

// ! If it has parameter ?force=1
if ( isset( $_GET['force'] ) ) {
	// ! Check if options update is enabled
	if ( ( (int) get_option( 'wc_settings_tab_dpdfrance_auto_update' ) ) === 0 ) {
		echo '[DPD] La mise à jour automatique des statuts est désactivée dans les paramètres.';
		exit;
	}
	updateOrderStatus();
} else {
	// ! Check if options update is enabled
	if ( ( (int) get_option( 'wc_settings_tab_dpdfrance_auto_update' ) ) === 0 ) {
		echo '[DPD] La mise à jour automatique des statuts est désactivée dans les paramètres.';
		exit;
	}
	$lastUpdate = (int) get_option( 'dpdfrance_last_tracking' );
	// ! Check if last tracking call is more than 1 hour old and update counter
	if ( ( time() - $lastUpdate ) < 3600 ) {
		echo '[DPD] La mise à jour des statuts est exécutée une fois par heure, veuillez réessayer plus tard. <br/>';
		echo 'Dernière actualisation : ' . date( 'd/m/Y - H:i:s', $lastUpdate ) . '<br/>';
		echo 'Prochaine actualisation : ' . date( 'd/m/Y - H:i:s', ( $lastUpdate + 3600 ) ) . '<br/>';
		exit;
	}
	updateOrderStatus();
}

function updateOrderStatus() {
	global $wpdb;

	$output = '';
	/* Update last tracking timestamp */
	$wpdb->get_var( $wpdb->prepare( "UPDATE $wpdb->options SET `option_value` = %d WHERE `option_name` = %s", time(), 'dpdfrance_last_tracking' ) );

	/* Retrieve orders ID by 'publish','wc-pending','wc-processing','wc-on-hold' statuses */
	$post_ids = WC_DPDFrance_Tools::get_orders_id_except_delivered_and_completed_status();

	/* If there are no DPD orders, quit */
	if ( empty( $post_ids ) ) {
		echo 'DPD France - No orders to update.';
		exit;
	}

	echo '<h3 style="color:green">DPD France - Sync started</h3><br/>';

// * Collect order data
	foreach ( $post_ids as $post_id ) {
		$statuslist = [];
		/* Retrieve order details from its ID */
		$order                    = wc_get_order( $post_id );
		$order_id                 = $order->get_order_number();
		$post_status              = ( WC_DPDFrance_Tools::is_from_wc3() ? get_post_status( $post_id ) : $order->post_status );
		$order_shipping_method_id = WC_DPDFrance_Tools::get_order_shipping_method_id( $order );


		if (
			stripos( $order_shipping_method_id, 'dpdfrance_' ) !== false &&
			( $post_status === get_option( 'wc_settings_tab_dpdfrance_etape_expedition' ) || $post_status === get_option( 'wc_settings_tab_dpdfrance_etape_expediee' ) )
		) {

			$depot_code   = WC_DPDFrance_Tools::get_depot_code( $order );
			$shipper_code = WC_DPDFrance_Tools::get_shipper_code( $order );
			$service_url  = 'http://webtrace.dpd.fr/dpd-webservices/webtrace_service.asmx?WSDL';
			$variables    = [
				'customer_center'          => '3',
				'customer'                 => '1064',
				'password'                 => 'Pr2%5sHg',
				'reference'                => $order_id,
				'shipping_date'            => '',
				'shipping_customer_center' => $depot_code,
				'shipping_customer'        => $shipper_code,
				'language'                 => 'F',
			];

			// Call WS for traces by Ref
			try {
				$client   = new SoapClient( $service_url, [ 'connection_timeout' => 5, 'exceptions' => true ] );
				$response = $client->getShipmentTraceByReferenceGlobalWithCenterAsArray( $variables );
				$result   = $response->getShipmentTraceByReferenceGlobalWithCenterAsArrayResult->clsShipmentTrace;

				if ( ! empty( $result->LastError ) ) {
					$output .= 'Order' . ' ' . $order_id . ' - ' . 'Error: ' . $result->LastError . '<br/>';
				} else {
					// Only one parcel per reference
					if ( ! is_array( $result ) ) {
						$traces        = $result->Traces->clsTrace;
						$returned_ref  = $result->Reference;
						$returned_ref2 = $result->Reference2;
						if ( $order_id === $returned_ref || $order_id === $returned_ref2 ) {
							// Parcels with only one status
							if ( ! is_array( $traces ) ) {
								// Exclude CEDI-only parcels
								if ( $traces->StatusNumber != 8 ) {
									$statuslist[ $result->ShipmentNumber ][] = $traces->StatusNumber;
								}
							} else {
								// Parcel with multiple statuses
								foreach ( $traces as $status ) {
									$statuslist[ $result->ShipmentNumber ][] = $status->StatusNumber;
								}
							}
						}
					} else {
						// Multiple parcels per reference
						foreach ( $result as $shipment ) {
							$returned_ref  = $shipment->Reference;
							$returned_ref2 = $result->Reference2;
							if ( $order_id === $returned_ref || $order_id === $returned_ref2 ) {
								$variables2 = [
									'customer_center' => '3',
									'customer'        => '1064',
									'password'        => 'Pr2%5sHg',
									'shipmentnumber'  => $shipment->ShipmentNumber,
								];
								$response2  = $client->getShipmentTrace( $variables2 );
								$traces     = $response2->getShipmentTraceResult->Traces->clsTrace;
								// Parcels with only one status
								if ( ! is_array( $traces ) ) {
									// Exclude CEDI-only parcels
									if ( $traces->StatusNumber == 8 ) {
										continue;
									}
									$statuslist[ $shipment->ShipmentNumber ][] = $traces->StatusNumber;
								} else {
									// Parcel with multiple statuses
									foreach ( $traces as $status ) {
										$statuslist[ $shipment->ShipmentNumber ][] = $status->StatusNumber;
									}
								}
							}
							break; // Stop at first parcel
						}
					}

					if ( ! empty( $statuslist ) ) {
						// Check delivery state
						$tracking_number = ( key( $statuslist ) );
						$delivery_state  = 0;
						foreach ( $statuslist as $events ) {
							// Check if en-route event has been applied
							if ( array_intersect( [ 10, 28, 44, 89 ], $events ) ) {
								$delivery_state = 1;
							}
							// Check if delivered event has been applied
							if ( array_intersect( [ 40, 400 ], $events ) ) {
								$delivery_state = 2;
							}
						}

						// Add tracking number if empty
						$note_sent = 0;
						foreach ( $order->get_customer_order_notes() as $note ) {
							if ( stripos( $note->comment_content, 'dpd.fr/trace' ) !== false ) {
								$note_sent = 1;
							}
						}
						if ( $note_sent == 0 ) {
							/* Prepare customer note */
							$note = __( 'Dear customer, you can follow your DPD parcel delivery by clicking this link:', 'woocommerce-dpdfrance' );
							$link = 'http://www.dpd.fr/tracex_' . $order_id . '_' . $depot_code . $shipper_code;
							$href = '<a href="' . $link . '">' . $link . '</a>';

							/* Add customer note to order */
							if ( is_user_logged_in() && current_user_can( 'manage_woocommerce' ) ) {
								$user                 = get_user_by( 'id', get_current_user_id() );
								$comment_author       = $user->display_name;
								$comment_author_email = $user->user_email;
							} else {
								$comment_author       = __( 'WooCommerce', 'woocommerce-dpdfrance' );
								$comment_author_email = strtolower( __( 'WooCommerce', 'woocommerce-dpdfrance' ) ) . '@';
								$comment_author_email .= isset( $_SERVER['HTTP_HOST'] ) ? str_replace( 'www.', '', $_SERVER['HTTP_HOST'] ) : 'noreply.com';
								$comment_author_email = sanitize_email( $comment_author_email );
							}

							$comment_post_ID    = $order_id;
							$comment_author_url = '';
							$comment_content    = $note . ' ' . $href;
							$comment_agent      = 'WooCommerce';
							$comment_type       = 'order_note';
							$comment_parent     = 0;
							$comment_approved   = 1;
							$commentdata        = apply_filters( 'woocommerce_new_order_note_data', compact( 'comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_agent', 'comment_type', 'comment_parent', 'comment_approved' ), [
								'order_id'         => $order_id,
								'is_customer_note' => 1,
							] );

							$comment_id = wp_insert_comment( $commentdata );
							add_comment_meta( $comment_id, 'is_customer_note', 1 );
							do_action( 'woocommerce_new_customer_note', [
								'order_id'      => $order_id,
								'customer_note' => $note . ' ' . $href,
							] );
							$output .= 'Order' . ' ' . $order_id . ' - ' . 'Tracking number' . ' ' . $tracking_number . ' ' . 'sent to consignee' . '<br/>';
						}

						/* Update to delivered */
						if (
							$delivery_state == 2 &&
							$post_status != get_option( 'wc_settings_tab_dpdfrance_etape_livre' )
						) {
							$order->update_status( get_option( 'wc_settings_tab_dpdfrance_etape_livre' ) );
							$output .= 'Order' . ' ' . $order_id . ' - ' . 'Tracking number' . ' ' . $tracking_number . ' ' . 'is delivered' . '<br/>';
						} else {
							/* Update to shipped */
							if (
								$delivery_state == 1 &&
								$post_status != get_option( 'wc_settings_tab_dpdfrance_etape_expediee' ) &&
								$post_status != get_option( 'wc_settings_tab_dpdfrance_etape_livre' )
							) {
								$order->update_status( get_option( 'wc_settings_tab_dpdfrance_etape_expediee' ) );
								$output .= 'Order' . ' ' . $order_id . ' - ' . 'Parcel' . ' ' . $tracking_number . ' ' . 'is handled by DPD' . '<br/>';
							} else {
								$output .= 'Order' . ' ' . $order_id . ' - ' . 'No update for parcel' . ' ' . $tracking_number . '<br/>';
							}
						}
					} else {
						$output .= 'Order' . ' ' . $order_id . ' - ' . 'Parcel is found, not yet handled by DPD' . '<br/>';
					}
				}
			} catch ( Exception $e ) {
				$output .= 'Order' . ' ' . $order_id . ' - ' . 'Error: ' . $e->getMessage() . '<br/>';
				continue;
			}
		}
	}

	echo $output;
	echo '<h3 style="color:red">DPD France - Sync complete.</h3><br/>';
}


