/**
 * Copyright © Lyra Network and contributors.
 * This file is part of Sogecommerce plugin for WooCommerce. See COPYING.md for license details.
 *
 * @author    Lyra Network (https://www.lyra.com/)
 * @author    Geoffrey Crofte, Alsacréations (https://www.alsacreations.fr/)
 * @copyright Lyra Network and contributors
 * @license   http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU General Public License (GPL v2)
 */

/**
 * External dependencies.
 */
import { registerPaymentMethod } from '@woocommerce/blocks-registry';

/**
 * Internal dependencies.
 */
import { getSogecommerceServerData } from './sogecommerce-utils';

const PAYMENT_METHOD_NAME = 'sogecommercefranfinance';
var sogecommerce_data = getSogecommerceServerData(PAYMENT_METHOD_NAME);

const Content = () => {
    var fields = <ul dangerouslySetInnerHTML={{__html: sogecommerce_data?.payment_fields}} />;
    jQuery('.wc-block-components-checkout-place-order-button').on('click', sogecommerce_get_selected_option(['sogecommercefranfinance_option']));

    return (
        <div>
            { sogecommerce_data?.description }
            { fields }
        </div>
    );
};

const Label = () => {
    const styles = {
        divWidth: {
            width: '95%'
        },
        imgFloat: {
            float: 'right'
        }
    }

    return (
        <div style={ styles.divWidth }>
            <span>{ sogecommerce_data?.title}</span>
            <img
                style={ styles.imgFloat }
                src={ sogecommerce_data?.logo_url }
                alt={ sogecommerce_data?.title }
            />
        </div>
    );
};

registerPaymentMethod({
    name: PAYMENT_METHOD_NAME,
    label: <Label />,
    ariaLabel: 'Sogecommerce payment method',
    canMakePayment: () => true,
    content: <Content />,
    edit: <Content />,
    supports: {
        features: sogecommerce_data?.supports ?? [],
    },
});
